/* - Analog full -
 * This example demonstrates the basic usage of a Phidget Analog.  It
 * demonstrates the manipulation of the enabled state and voltage of the channel output,
 * as well as displays the data from generated events.
 *
 * Please note that this example was designed to work with only one Phidget
 * Analog connected.
 *
 * Copyright 2011 Phidgets Inc.
 * This work is licensed under the Creative Commons Attribution 2.5 Canada License.
 * To view a copy of this license, visit http://creativecommons.org/licenses/by/2.5/ca/
 */
package Analog;

import com.phidgets.AnalogPhidget;
import com.phidgets.PhidgetException;
import javax.swing.JCheckBox;
import javax.swing.JOptionPane;
import javax.swing.JSlider;
import javax.swing.JTextField;

import listeners.*;

public class Analog extends javax.swing.JFrame {

    private static String runArgs[];
    private AnalogPhidget an;
    private ANAttachListener attach_listener;
    private ANDetachListener detach_listener;
    private ANErrorListener error_listener;
    private JCheckBox enabledArray[];
    private JSlider voltageSliderArray[];
    private JTextField voltageTxtArray[];

    public Analog() {
        initComponents();
    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        jPanel1 = new javax.swing.JPanel();
        attachedTxt = new javax.swing.JTextField();
        jLabel1 = new javax.swing.JLabel();
        jScrollPane1 = new javax.swing.JScrollPane();
        nameTxt = new javax.swing.JTextArea();
        jLabel2 = new javax.swing.JLabel();
        serialTxt = new javax.swing.JTextField();
        jLabel3 = new javax.swing.JLabel();
        versionTxt = new javax.swing.JTextField();
        jLabel4 = new javax.swing.JLabel();
        numChannelsTxt = new javax.swing.JTextField();
        jLabel5 = new javax.swing.JLabel();
        channelPanel = new javax.swing.JPanel();
        channelLabel0 = new javax.swing.JLabel();
        jLabel7 = new javax.swing.JLabel();
        jLabel8 = new javax.swing.JLabel();
        channelLabel1 = new javax.swing.JLabel();
        channelLabel2 = new javax.swing.JLabel();
        channelLabel3 = new javax.swing.JLabel();
        voltageSlider0 = new javax.swing.JSlider();
        voltageTxt0 = new javax.swing.JTextField();
        enabledChk0 = new javax.swing.JCheckBox();
        enabledChk1 = new javax.swing.JCheckBox();
        enabledChk2 = new javax.swing.JCheckBox();
        enabledChk3 = new javax.swing.JCheckBox();
        voltageSlider1 = new javax.swing.JSlider();
        voltageSlider2 = new javax.swing.JSlider();
        voltageSlider3 = new javax.swing.JSlider();
        voltageTxt1 = new javax.swing.JTextField();
        voltageTxt2 = new javax.swing.JTextField();
        voltageTxt3 = new javax.swing.JTextField();
        jLabel6 = new javax.swing.JLabel();

        setDefaultCloseOperation(javax.swing.WindowConstants.EXIT_ON_CLOSE);
        setTitle("PhidgetAnalog-full");
        addWindowListener(new java.awt.event.WindowAdapter() {
            public void windowOpened(java.awt.event.WindowEvent evt) {
                formWindowOpened(evt);
            }
        });

        jPanel1.setBorder(javax.swing.BorderFactory.createTitledBorder("Analog Info"));
        jPanel1.setLayout(new org.netbeans.lib.awtextra.AbsoluteLayout());

        attachedTxt.setEditable(false);
        jPanel1.add(attachedTxt, new org.netbeans.lib.awtextra.AbsoluteConstraints(97, 33, 200, -1));

        jLabel1.setText("Attached:");
        jPanel1.add(jLabel1, new org.netbeans.lib.awtextra.AbsoluteConstraints(43, 36, -1, -1));

        nameTxt.setBackground(javax.swing.UIManager.getDefaults().getColor("TextField.disabledBackground"));
        nameTxt.setColumns(20);
        nameTxt.setEditable(false);
        nameTxt.setLineWrap(true);
        nameTxt.setRows(3);
        nameTxt.setTabSize(2);
        nameTxt.setWrapStyleWord(true);
        nameTxt.setPreferredSize(new java.awt.Dimension(200, 58));
        jScrollPane1.setViewportView(nameTxt);

        jPanel1.add(jScrollPane1, new org.netbeans.lib.awtextra.AbsoluteConstraints(97, 68, 200, -1));

        jLabel2.setText("Name:");
        jPanel1.add(jLabel2, new org.netbeans.lib.awtextra.AbsoluteConstraints(60, 68, -1, -1));

        serialTxt.setEditable(false);
        jPanel1.add(serialTxt, new org.netbeans.lib.awtextra.AbsoluteConstraints(97, 144, 200, -1));

        jLabel3.setText("Serial No:");
        jPanel1.add(jLabel3, new org.netbeans.lib.awtextra.AbsoluteConstraints(41, 147, -1, -1));

        versionTxt.setEditable(false);
        jPanel1.add(versionTxt, new org.netbeans.lib.awtextra.AbsoluteConstraints(97, 180, 200, -1));

        jLabel4.setText("Version:");
        jPanel1.add(jLabel4, new org.netbeans.lib.awtextra.AbsoluteConstraints(48, 180, -1, -1));

        numChannelsTxt.setEditable(false);
        jPanel1.add(numChannelsTxt, new org.netbeans.lib.awtextra.AbsoluteConstraints(97, 216, 200, -1));

        jLabel5.setText("# Channels:");
        jPanel1.add(jLabel5, new org.netbeans.lib.awtextra.AbsoluteConstraints(30, 220, -1, 20));

        channelPanel.setBorder(javax.swing.BorderFactory.createTitledBorder("Channel Output"));
        channelPanel.setLayout(new org.netbeans.lib.awtextra.AbsoluteLayout());

        channelLabel0.setText("0");
        channelPanel.add(channelLabel0, new org.netbeans.lib.awtextra.AbsoluteConstraints(40, 60, -1, -1));

        jLabel7.setText("Voltage(V)");
        channelPanel.add(jLabel7, new org.netbeans.lib.awtextra.AbsoluteConstraints(210, 30, -1, -1));

        jLabel8.setText("Enabled");
        channelPanel.add(jLabel8, new org.netbeans.lib.awtextra.AbsoluteConstraints(90, 30, -1, -1));

        channelLabel1.setText("1");
        channelPanel.add(channelLabel1, new org.netbeans.lib.awtextra.AbsoluteConstraints(40, 90, -1, -1));

        channelLabel2.setText("2");
        channelPanel.add(channelLabel2, new org.netbeans.lib.awtextra.AbsoluteConstraints(40, 120, -1, -1));

        channelLabel3.setText("3");
        channelPanel.add(channelLabel3, new org.netbeans.lib.awtextra.AbsoluteConstraints(40, 150, -1, -1));

        voltageSlider0.addChangeListener(new javax.swing.event.ChangeListener() {
            public void stateChanged(javax.swing.event.ChangeEvent evt) {
                voltageSlider0StateChanged(evt);
            }
        });
        channelPanel.add(voltageSlider0, new org.netbeans.lib.awtextra.AbsoluteConstraints(135, 60, 110, -1));

        voltageTxt0.setEditable(false);
        channelPanel.add(voltageTxt0, new org.netbeans.lib.awtextra.AbsoluteConstraints(255, 60, 40, -1));

        enabledChk0.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                enabledChk0ActionPerformed(evt);
            }
        });
        channelPanel.add(enabledChk0, new org.netbeans.lib.awtextra.AbsoluteConstraints(90, 60, -1, -1));

        enabledChk1.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                enabledChk1ActionPerformed(evt);
            }
        });
        channelPanel.add(enabledChk1, new org.netbeans.lib.awtextra.AbsoluteConstraints(90, 90, -1, -1));

        enabledChk2.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                enabledChk2ActionPerformed(evt);
            }
        });
        channelPanel.add(enabledChk2, new org.netbeans.lib.awtextra.AbsoluteConstraints(90, 120, -1, -1));

        enabledChk3.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                enabledChk3ActionPerformed(evt);
            }
        });
        channelPanel.add(enabledChk3, new org.netbeans.lib.awtextra.AbsoluteConstraints(90, 150, -1, -1));

        voltageSlider1.addChangeListener(new javax.swing.event.ChangeListener() {
            public void stateChanged(javax.swing.event.ChangeEvent evt) {
                voltageSlider1StateChanged(evt);
            }
        });
        channelPanel.add(voltageSlider1, new org.netbeans.lib.awtextra.AbsoluteConstraints(135, 90, 110, -1));

        voltageSlider2.addChangeListener(new javax.swing.event.ChangeListener() {
            public void stateChanged(javax.swing.event.ChangeEvent evt) {
                voltageSlider2StateChanged(evt);
            }
        });
        channelPanel.add(voltageSlider2, new org.netbeans.lib.awtextra.AbsoluteConstraints(135, 120, 110, -1));

        voltageSlider3.addChangeListener(new javax.swing.event.ChangeListener() {
            public void stateChanged(javax.swing.event.ChangeEvent evt) {
                voltageSlider3StateChanged(evt);
            }
        });
        channelPanel.add(voltageSlider3, new org.netbeans.lib.awtextra.AbsoluteConstraints(135, 150, 110, -1));

        voltageTxt1.setEditable(false);
        channelPanel.add(voltageTxt1, new org.netbeans.lib.awtextra.AbsoluteConstraints(255, 90, 40, -1));

        voltageTxt2.setEditable(false);
        channelPanel.add(voltageTxt2, new org.netbeans.lib.awtextra.AbsoluteConstraints(255, 120, 40, -1));

        voltageTxt3.setEditable(false);
        channelPanel.add(voltageTxt3, new org.netbeans.lib.awtextra.AbsoluteConstraints(255, 150, 40, -1));

        jLabel6.setText("Channel #");
        channelPanel.add(jLabel6, new org.netbeans.lib.awtextra.AbsoluteConstraints(20, 30, -1, -1));

        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(getContentPane());
        getContentPane().setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.TRAILING)
                    .addComponent(channelPanel, javax.swing.GroupLayout.Alignment.LEADING, javax.swing.GroupLayout.DEFAULT_SIZE, 320, Short.MAX_VALUE)
                    .addComponent(jPanel1, javax.swing.GroupLayout.Alignment.LEADING, javax.swing.GroupLayout.PREFERRED_SIZE, 320, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addContainerGap())
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addContainerGap()
                .addComponent(jPanel1, javax.swing.GroupLayout.PREFERRED_SIZE, 252, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(channelPanel, javax.swing.GroupLayout.PREFERRED_SIZE, 185, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addContainerGap(javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );

        pack();
    }// </editor-fold>//GEN-END:initComponents

    private void formWindowOpened(java.awt.event.WindowEvent evt) {//GEN-FIRST:event_formWindowOpened

        this.setSize(357, 311);
        channelPanel.setVisible(false);
        channelPanel.setEnabled(false);

        enabledArray = new JCheckBox[4];
        enabledArray[0] = enabledChk0;
        enabledArray[1] = enabledChk1;
        enabledArray[2] = enabledChk2;
        enabledArray[3] = enabledChk3;

        voltageSliderArray = new JSlider[4];
        voltageSliderArray[0] = voltageSlider0;
        voltageSliderArray[1] = voltageSlider1;
        voltageSliderArray[2] = voltageSlider2;
        voltageSliderArray[3] = voltageSlider3;

        voltageTxtArray = new JTextField[4];
        voltageTxtArray[0] = voltageTxt0;
        voltageTxtArray[1] = voltageTxt1;
        voltageTxtArray[2] = voltageTxt2;
        voltageTxtArray[3] = voltageTxt3;

        for (int i = 0; i < 4; i++) {


            enabledArray[i].setVisible(false);
            enabledArray[i].setEnabled(false);

            voltageTxtArray[i].setVisible(false);
            voltageTxtArray[i].setEnabled(false);

            voltageSliderArray[i].setVisible(false);
            voltageSliderArray[i].setEnabled(false);
        }

        try {
            an = new AnalogPhidget();

            attach_listener = new ANAttachListener(this, this.channelPanel, this.attachedTxt, this.nameTxt,
                    this.serialTxt, this.versionTxt, this.numChannelsTxt, this.enabledArray, this.voltageSliderArray, this.voltageTxtArray);

            detach_listener = new ANDetachListener(this, this.channelPanel, this.attachedTxt, this.nameTxt,
                    this.serialTxt, this.versionTxt, this.numChannelsTxt, this.enabledArray, this.voltageSliderArray, this.voltageTxtArray);

            error_listener = new ANErrorListener(this);

            an.addAttachListener(attach_listener);
            an.addDetachListener(detach_listener);
            an.addErrorListener(error_listener);

            //This assumes that if there is a command line argument, it is a serial number
            //and we try to open that specific device. Otherwise, open any device.
            if ((runArgs.length > 1) && (runArgs[1].equals("remote"))) {
                an.open(Integer.parseInt(runArgs[0]), null);
            }
            if (runArgs.length > 0) {
                an.open(Integer.parseInt(runArgs[0]));
            } else {
                an.openAny();
            }

        } catch (PhidgetException ex) {
            JOptionPane.showMessageDialog(this, ex.getDescription(), "Phidget Error" + ex.getErrorNumber(), JOptionPane.ERROR_MESSAGE);
        }

    }//GEN-LAST:event_formWindowOpened

    private void voltageSlider0StateChanged(javax.swing.event.ChangeEvent evt) {//GEN-FIRST:event_voltageSlider0StateChanged
        JSlider slider = (JSlider) evt.getSource();
        if (slider.isEnabled()) {
            try {
                an.setVoltage(0, slider.getValue() / 100.0);
                voltageTxt0.setText(Double.toString((slider.getValue()) / 100.0));
            } catch (PhidgetException ex) {
                JOptionPane.showMessageDialog(this, ex.getDescription(), "Phidget Error" + ex.getErrorNumber(), JOptionPane.ERROR_MESSAGE);
            }
        }
    }//GEN-LAST:event_voltageSlider0StateChanged

    private void enabledChk0ActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_enabledChk0ActionPerformed
        JCheckBox chk = (JCheckBox) evt.getSource();
        try {
            if (chk.isEnabled()) {
                an.setEnabled(0, enabledChk0.isSelected());
                chk.setText("");
            }
        } catch (PhidgetException ex) {
            JOptionPane.showMessageDialog(this, ex.getDescription(), "Phidget Error" + ex.getErrorNumber(), JOptionPane.ERROR_MESSAGE);
        }
    }//GEN-LAST:event_enabledChk0ActionPerformed

    private void voltageSlider1StateChanged(javax.swing.event.ChangeEvent evt) {//GEN-FIRST:event_voltageSlider1StateChanged
  JSlider slider = (JSlider) evt.getSource();
        if (slider.isEnabled()) {
            try {
                an.setVoltage(1, slider.getValue() / 100.0);
                voltageTxt1.setText(Double.toString((slider.getValue()) / 100.0));
            } catch (PhidgetException ex) {
                JOptionPane.showMessageDialog(this, ex.getDescription(), "Phidget Error" + ex.getErrorNumber(), JOptionPane.ERROR_MESSAGE);
            }
        }
    }//GEN-LAST:event_voltageSlider1StateChanged

    private void voltageSlider2StateChanged(javax.swing.event.ChangeEvent evt) {//GEN-FIRST:event_voltageSlider2StateChanged
  JSlider slider = (JSlider) evt.getSource();
        if (slider.isEnabled()) {
            try {
                an.setVoltage(2, slider.getValue() / 100.0);
                voltageTxt2.setText(Double.toString((slider.getValue()) / 100.0));
            } catch (PhidgetException ex) {
                JOptionPane.showMessageDialog(this, ex.getDescription(), "Phidget Error" + ex.getErrorNumber(), JOptionPane.ERROR_MESSAGE);
            }
        }
    }//GEN-LAST:event_voltageSlider2StateChanged

    private void voltageSlider3StateChanged(javax.swing.event.ChangeEvent evt) {//GEN-FIRST:event_voltageSlider3StateChanged
        JSlider slider = (JSlider) evt.getSource();
        if (slider.isEnabled()) {
            try {
                an.setVoltage(3, slider.getValue() / 100.0);
                voltageTxt3.setText(Double.toString((slider.getValue()) / 100.0));
            } catch (PhidgetException ex) {
                JOptionPane.showMessageDialog(this, ex.getDescription(), "Phidget Error" + ex.getErrorNumber(), JOptionPane.ERROR_MESSAGE);
            }
        }
    }//GEN-LAST:event_voltageSlider3StateChanged

    private void enabledChk1ActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_enabledChk1ActionPerformed
        JCheckBox chk = (JCheckBox) evt.getSource();
        try {
            if (chk.isEnabled()) {
                an.setEnabled(1, enabledChk1.isSelected());
                chk.setText("");
            }
        } catch (PhidgetException ex) {
            JOptionPane.showMessageDialog(this, ex.getDescription(), "Phidget Error" + ex.getErrorNumber(), JOptionPane.ERROR_MESSAGE);
        }
    }//GEN-LAST:event_enabledChk1ActionPerformed

    private void enabledChk2ActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_enabledChk2ActionPerformed
        JCheckBox chk = (JCheckBox) evt.getSource();
        try {
            if (chk.isEnabled()) {
                an.setEnabled(2, enabledChk2.isSelected());
                chk.setText("");
            }
        } catch (PhidgetException ex) {
            JOptionPane.showMessageDialog(this, ex.getDescription(), "Phidget Error" + ex.getErrorNumber(), JOptionPane.ERROR_MESSAGE);
        }
    }//GEN-LAST:event_enabledChk2ActionPerformed

    private void enabledChk3ActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_enabledChk3ActionPerformed
    JCheckBox chk = (JCheckBox) evt.getSource();
        try {
            if (chk.isEnabled()) {
                an.setEnabled(3, enabledChk3.isSelected());
                chk.setText("");
            }
        } catch (PhidgetException ex) {
            JOptionPane.showMessageDialog(this, ex.getDescription(), "Phidget Error" + ex.getErrorNumber(), JOptionPane.ERROR_MESSAGE);
        }
    }//GEN-LAST:event_enabledChk3ActionPerformed

    /**
     * @param args the command line arguments
     */
    public static void main(String args[]) {
        runArgs = args;
        java.awt.EventQueue.invokeLater(new Runnable() {

            public void run() {
                new Analog().setVisible(true);
            }
        });
    }
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JTextField attachedTxt;
    private javax.swing.JLabel channelLabel0;
    private javax.swing.JLabel channelLabel1;
    private javax.swing.JLabel channelLabel2;
    private javax.swing.JLabel channelLabel3;
    private javax.swing.JPanel channelPanel;
    private javax.swing.JCheckBox enabledChk0;
    private javax.swing.JCheckBox enabledChk1;
    private javax.swing.JCheckBox enabledChk2;
    private javax.swing.JCheckBox enabledChk3;
    private javax.swing.JLabel jLabel1;
    private javax.swing.JLabel jLabel2;
    private javax.swing.JLabel jLabel3;
    private javax.swing.JLabel jLabel4;
    private javax.swing.JLabel jLabel5;
    private javax.swing.JLabel jLabel6;
    private javax.swing.JLabel jLabel7;
    private javax.swing.JLabel jLabel8;
    private javax.swing.JPanel jPanel1;
    private javax.swing.JScrollPane jScrollPane1;
    private javax.swing.JTextArea nameTxt;
    private javax.swing.JTextField numChannelsTxt;
    private javax.swing.JTextField serialTxt;
    private javax.swing.JTextField versionTxt;
    private javax.swing.JSlider voltageSlider0;
    private javax.swing.JSlider voltageSlider1;
    private javax.swing.JSlider voltageSlider2;
    private javax.swing.JSlider voltageSlider3;
    private javax.swing.JTextField voltageTxt0;
    private javax.swing.JTextField voltageTxt1;
    private javax.swing.JTextField voltageTxt2;
    private javax.swing.JTextField voltageTxt3;
    // End of variables declaration//GEN-END:variables
}
